 LST OFF
* TCP CHAT DEMO FOR W5100/UTHERNET II
* BY D. FINNIGAN
* JANUARY 2016
*
*
* SLOT 2 I/O ADDRESSES FOR THE W5100
*
WMODE EQU $C0A4
WADRH EQU $C0A5
WADRL EQU $C0A6
WDATA EQU $C0A7
*
*
* IMPORTANT LOCATIONS WITHIN THE W5100
*
SUBR EQU $0005 ; SUBNET MASK
MACADDR EQU $0009 ; MAC ADDRESS
SRCIP EQU $000F ; SOURCE IP ADDRESS
RMSR EQU $001A ; RECEIVE BUFFER SIZE
*
* SOCKET 0 LOCATIONS
*
S0MR EQU $0400 ; SOCKET 0 MODE REGISTER
S0CR EQU $0401 ; COMMAND REGISTER
S0IR EQU $0402 ; INTERRUPT REGISTER
S0SR EQU $0403 ; STATUS REGISTER
S0LOCALPORT EQU $0404 ; LOCAL PORT
S0FORADDR EQU $040C ; FOREIGN ADDRESS
S0FORPORT EQU $0410 ; FOREIGN PORT
S0MSS EQU $0412 ; MAXIMUM SEGMENT SIZE
S0PROTO EQU $0414 ; IP PROTOCOL
S0TOS EQU $0415 ; DS/ECN (FORMER TOS)
S0TTL EQU $0416 ; IP TIME TO LIVE
S0TXFSR EQU $0420 ; TX FREE SIZE REGISTER
S0TXRR EQU $0422 ; TX READ POINTER REGISTER
S0TXWR EQU $0424 ; TX WRITE POINTER REGISTER
S0RXRSR EQU $0426 ; RX RECEIVED SIZE REGISTER
S0RXRD EQU $0428 ; RX READ POINTER REGISTER
*
* SOCKET 0 PARAMETERS
*
RXBASE EQU $6000 ; SOCKET 0 RX BASE ADDR
RXMASK EQU $1FFF ; SOCKET 0 8 KB ADDRESS MASK
TXBASE EQU $4000 ; SOCKET 0 TX BASE ADDR
TXMASK EQU RXMASK ; SOCKET 0 TX MASK = RX MASK
*
*
* SOCKET COMMANDS
*
SCOPEN EQU $01 ; OPEN
SCLISTEN EQU $02 ; LISTEN
SCCONNECT EQU $04 ; CONNECT
SCDISCON EQU $08 ; DISCONNECT
SCCLOSE EQU $10 ; CLOSE
SCSEND EQU $20 ; SEND
SCSENDMAC EQU $21 ; SEND MAC
SCSENDKEEP EQU $22 ; SEND KEEP ALIVE
SCRECV EQU $40 ; RECV
*
* SOCKET STATUS
*
STCLOSED EQU $00 ; CLOSED
STINIT EQU $13 ; SOCK INIT
STLISTEN EQU $14 ; SOCK LISTEN
STESTABLISHED EQU $17 ; SOCK ESTABLISHED
STCLOSEWAIT EQU $1C ; SOCK CLOSE WAIT
STUDP EQU $22 ; UDP
STIPRAW EQU $32 ; IP RAW
STMACRAW EQU $42 ; MAC RAW
STPPOE EQU $5F ; PPOE
*
* MONITOR SUBROUTINES
*
DOSWARM EQU $3D0
KBD EQU $C000
KBDSTRB EQU $C010
PRNTAX EQU $F941
BELL1 EQU $FBDD
VTAB EQU $FC22
HOME EQU $FC58
CLREOL EQU $FC9C
RDKEY EQU $FD0C
GETLN EQU $FD6A
COUT EQU $FDED
PRBYTE EQU $FDDA
*
* ZERO-PAGE STORAGE
*
WNDTOP EQU $22
WNDBTM EQU $23
CH EQU $24
CV EQU $25
PROMPT EQU $33
PTR EQU $06 ; 2 BYTES FOR APPLE BUFFER
GETSIZE EQU $08 ; 2 BYTES FOR RX_RSR
GETOFFSET EQU $0A ; 2 BYTES FOR OFFSET ADDR
GETSTARTADR EQU $0C ; 2 BYTES FOR PHYSICAL ADDR
OUTPBUF EQU $18 ; POINTER TO OUTGOING DATA
OUTPLEN EQU $1A ; LENGTH OF OUTGOING DATA
KEYLEN EQU $1C ; LENGTH OF OUR CHAT LINE
*
*
LOCALPORT EQU 20000
*
 JMP START
*
* STORAGE FOR LOCAL NICKNAME
* AND REMOTE NICKNAME - NULL TERMINATED
*
NICKLEN EQU 23
MYNICK DS NICKLEN+1
HISNICK DS NICKLEN+1
*
*
* RESET AND CONFIGURE W5100
*
*
START
 LDA #$80 ; RESET
 STA WMODE
 LDA #3 ; CONFIGURE WITH AUTO-INC
 STA WMODE
*
* ASSIGN MAC ADDRESS
*
 LDA #>MACADDR
 STA WADRH
 LDA #<MACADDR
 STA WADRL
 LDX #0
:L LDA MAC,X
 STA WDATA ; USING AUTO-INC HERE
 INX
 CPX #6 ; COMPLETED?
 BNE :L
 JMP SETSRCADDR ; MOVE ON
*
MAC HEX 0008DC010203 ; MAC ADDRESS TO ASSIGN
*
*
* ASSIGN A SOURCE IP ADDRESS
*
SETSRCADDR
 LDA #<SRCIP
 STA WADRL
 LDX #0
:L LDA SRCADDR,X
 STA WDATA
 INX
 CPX #4
 BNE :L
 JMP SETSUBMASK
*
SRCADDR HEX C0A80205 ; 192.168.2.5
*
*
* SET SUBNET MASK - 255.255.255.0
*
SETSUBMASK
 LDA #<SUBR
 STA WADRL
 LDA #255
 STA WDATA
 STA WDATA
 STA WDATA
 LDA #0
 STA WDATA
*
*
* CONFIGURE BUFFER SIZES
*
SETBUFFERS
 LDA #<RMSR
 STA WADRL
 LDA #3 ; 8 KB TO SOCKET 0
 STA WDATA ; SET RECEIVE BUFFER
 STA WDATA ; SET TRANSMIT BUFFER
*
* CONFIGURE SOCKET 0 FOR TCP
*
 LDA #>S0MR
 STA WADRH
 LDA #<S0MR
 STA WADRL
 LDA #1 ; TCP MODE
 STA WDATA
*
* SET LOCAL PORT NUMBER
*
 LDA #<S0LOCALPORT
 STA WADRL
 LDA #>LOCALPORT ; HIGH BYTE OF LOCAL PORT
 STA WDATA
 LDA #<LOCALPORT ; LOW BYTE
 STA WDATA
*
* CLEAR SCREEN AND PRINT TITLE MESSAGE
*
CLEARSCREEN
 JSR HOME
 LDY #0
:L LDA :MSG1,Y
 BEQ :LDONE
 JSR COUT
 INY
 BNE :L
:MSG1 ASC "UTHERNET II TCP CHAT DEMO"
 HEX 8D8D
 ASC "ENTER YOUR NICKNAME "
 HEX 00
:LDONE
* ASK FOR NICKNAME
 LDA #">"
 STA PROMPT
 JSR GETLN
 CPX #NICKLEN+1 ; CHECK NAME LENGTH
 BCC :SETMYNICK ; LESS THAN
 LDX #NICKLEN
:SETMYNICK
 LDA #0
 STA MYNICK,X
 DEX
:L2 LDA $200,X
 STA MYNICK,X
 DEX
 BPL :L2
*
* ASK FOR ACTIVE OR PASSIVE OPEN
*
ASKACTIVE
 LDA #$8D
 JSR COUT
 LDY #0
:L LDA :MSG,Y
 BEQ :LDONE
 JSR COUT
 INY
 BNE :L
:MSG ASC "DO YOU WANT TO-"
 HEX 8D8D
 ASC "C)ONNECT TO THE OTHER GUY NOW"
 HEX 8D
 ASC " -OR-"
 HEX 8D
 ASC "W)AIT FOR OTHER GUY TO CONNECT TO YOU?"
 HEX 8D00
:LDONE
:GETKEY JSR RDKEY
 CMP #"Q" ; QUIT
 BNE :CHECKESC
 JMP DOSWARM
:CHECKESC
 CMP #$9B
 BNE :CHECKC
 JMP DOSWARM
:CHECKC
 CMP #"C"
 BEQ OPENACTIVE
 CMP #"c"
 BEQ OPENACTIVE
 CMP #"W"
 BNE :CHECKC2
 JMP LISTEN
:CHECKC2
 CMP #"w"
 BNE :INVALID
 JMP LISTEN
* INVALID SELECTION
:INVALID
 JSR BELL1
 JMP :GETKEY
*
* OPEN AN ACTIVE CONNECTION
*
OPENACTIVE
 JSR SETFORADDR
 JSR CONNECTTCP
*
* WHEN CONTROL DROPS DOWN TO HERE WE'VE GOT AN
* ESTABLISHED TCP CONNECTION
 JSR SENDNICK
 JMP INITCHAT
*
* SEND NICKNAME
* THE FORMAT IS TO PREPEND AN ESC AND AN 'N'
* BEFORE THE ACTUAL NICKNAME
*
SENDNICK
 LDA #$9B ;ESC
 STA $200
 LDA #"N"
 STA $201
 LDX #2
 LDY #0
:L LDA MYNICK,Y
 STA $200,X
 INX
 INY
 CPY #NICKLEN+1
 BNE :L
 LDA #NICKLEN+3 ; TOTAL LENGTH OF DATA
 STA OUTPLEN
 LDA #0
 STA OUTPLEN+1
 LDA #<$0200 ; LOCATION OF DATA
 STA OUTPBUF
 LDA #>$0200
 STA OUTPBUF+1
 JSR SEND
 RTS
*
* INIT CHAT
*
INITCHAT
 JSR HOME
 LDA #0
 STA KEYLEN
 LDA #23
 STA CV
 JSR VTAB
 LDA #">"
 JSR COUT
 LDA #0
 STA CV
 JSR VTAB
*
* MAIN EVENT LOOP
* - CHECK TCP FOR NEW DATA
* - CHECK KEYBOARD FOR INPUT
*
MAINLOOP
 JSR CHECKRECV ; ANY NEW DATA
 BCS :CHECKKEY ; NO
*
* NEW DATA TO PROCESS
* GETSIZE IS LENGTH OF DATA
* PTR IS BUFFER POINTER (USUALLY $5002)
 LDY #0
 LDA (PTR),Y
 CMP #$9B ; CHECK FOR ESCAPE
 BNE :ADDLINE
 INY
 LDA (PTR),Y
 CMP #"N" ; CHECK FOR NICKNAME
 BNE :ADDLINE
* THIS IS THE OTHER GUY'S NICKNAME - COPY IT
 INY
 LDX #0
:NL LDA (PTR),Y
 BEQ :CHECKKEY
 CMP #$8A
 BEQ :CHECKKEY
 CMP #$8D
 BEQ :CHECKKEY
 STA HISNICK,X
 INY
 INX
 CPX #NICKLEN+1
 BNE :NL
 JMP :CHECKKEY
*
* IF WE GOT HERE, THEN THIS IS A NEW LINE OF TEXT TO ADD
*
:ADDLINE
 SEC ; SIGNAL IT'S NOT FROM US
 JSR ADDLINE ; PUT IT ON SCREEN
*
* NOW CHECK FOR KEYBOARD INPUT
*
:CHECKKEY
 LDA KBD
 BPL :NOKEY
 STA KBDSTRB
 CMP #$8D ; CHECK FOR CR
 BNE :NOTCR
 LDA KEYLEN ; ANYTHING TO SAY?
 BEQ :NOKEY ; PRETEND THIS DIDN'T HAPPEN
 CLC
 JSR ADDLINE ; ECHO ON SCREEN
* SEND TO REMOTE TCP
 LDA KEYLEN
 STA OUTPLEN
 LDA #0
 STA OUTPLEN+1
 LDA #<$0200
 STA OUTPBUF
 LDA #>$0200
 STA OUTPBUF+1
 JSR SEND
* RESET OUR INPUT LINE
 LDA #0
 STA KEYLEN
 LDA CV
 PHA
 LDA #23
 STA CV
 JSR VTAB
 LDA #0
 STA CH
 JSR CLREOL
 PLA
 STA CV
 JSR VTAB
 BEQ :NOKEY
:NOTCR
 CMP #$A0
 BCC :NOKEY ; FILTER UNRPRINTABLES
 CMP #$FF
 BEQ :NOKEY
 LDX KEYLEN
 INX  ; TO ACCOUNT FOR > PROMPT
 STX CH
 DEX
 STA $0200,X
 INC KEYLEN
 TAY
 LDA CV
 PHA
 TYA
 PHA ; CHARACTER
 LDA #23
 STA CV
 JSR VTAB
 PLA
 JSR COUT
 PLA
 STA CV
 JSR VTAB
:NOKEY
 JMP MAINLOOP
*
* ADD A NEW LINE TO THE SCREEN
* CARRY SET = FROM OTHER GUY
* CARRY CLR = FROM US
*
ADDLINE
 LDA #23
 STA WNDBTM ; DON'T KILL OUR INPUT LINE
 LDA #$8D
 PHP  ; NEED TO SAVE C
 JSR COUT
 PLP
 LDY #0
 BCS :OTHER ; TEXT RECEIVED FROM TCP
*
* PUT TEXT WE TYPED ON THE CHAT SCREEN
*
:NL LDA MYNICK,Y
 BEQ :NEXT
 JSR COUT
 INY
 BNE :NL
:NEXT
 LDA #":"
 JSR COUT
 LDA #" "
 JSR COUT
*
* TEXT LENGTH IN KEYLEN
*
 LDY #0
:KL LDA $0200,Y
 JSR COUT
 INY
 CPY KEYLEN
 BNE :KL
 JMP :RESTORE
*
* PRINT TEXT RECEIVED FROM TCP
*
:OTHER
:NL2 LDA HISNICK,Y
 BEQ :NEXT2
 JSR COUT
 INY
 BNE :NL2
:NEXT2
 LDA #":"
 JSR COUT
 LDA #" "
 JSR COUT
*
* PRINT TEXT
*
 LDY #0
:TEXTL
 LDA (PTR),Y
 CMP #$8A
 BEQ :SKIP
 CMP #$8D
 BEQ :SKIP
 JSR COUT
:SKIP INY
 CPY GETSIZE
 BNE :TEXTL
*
* RESTORE TEXT WINDOW
*
:RESTORE
 LDA #24
 STA WNDBTM
 RTS
*
*
* ----------------------------
*
* EVERYTHING BELOW HERE IS TCP
*
* ----------------------------
*
* LISTEN FOR AN INCOMING CONNECTION
*
LISTEN
 LDY #0
:L LDA :MSG,Y
 BEQ :LDONE
 JSR COUT
 INY
 BNE :L
:MSG HEX 8D
 ASC "LISTENING FOR CONNECTION ON PORT $"
 HEX 00
:LDONE
 LDA #>LOCALPORT
 LDX #<LOCALPORT
 JSR PRNTAX
 JSR LISTENTCP
* WHEN CONTROL DROPS DOWN TO HERE, WE'VE GOT AN
* ESTABLISHED TCP CONNECTION
 JSR SENDNICK ; SEND NICKNAME TO OTHER GUY
 JMP INITCHAT ; SETUP CHAT SCREEN
*
* SET FOREIGN ADDRESS
*
SETFORADDR
 LDA #<S0FORADDR
 STA WADRL
 LDX #0
:L2 LDA FADDR,X
 STA WDATA
 INX
 CPX #4
 BNE :L2
 JMP SETFORPORT
*
FADDR HEX C0A80201 ; 192.168.2.1
*
*
* SET FOREIGN PORT
*
SETFORPORT
 LDA #>LOCALPORT ; HIGH BYTE OF FOREIGN PORT
 STA WDATA ; ADDRESS POINTER IS AT FOREIGN PORT
 LDA #<LOCALPORT ; LOW BYTE OF PORT
 STA WDATA
*
* OPEN SOCKET (NOTE: THIS DOES NOT INITIATE A CONNECTION)
*
OPENSOCKET
 LDA #<S0CR
 STA WADRL
 LDA #SCOPEN ; OPEN COMMAND
 STA WDATA
*
* CHECK STATUS REGISTER TO SEE IF OPEN COMMAND SUCCEEDED
*
 LDA #<S0SR
 STA WADRL
 LDA WDATA
 CMP #STINIT ; IS IT SOCK_INIT?
 BEQ :OPENEDOK ; YES, CONTINUE
 LDY #0
:L LDA :SOCKERR,Y
 BEQ :LDONE
 JSR COUT
 INY
 BNE :L
:LDONE JMP DOSWARM
:SOCKERR ASC "UTHERNET II: COULD NOT OPEN SOCKET!"
 HEX 8D00
:OPENEDOK RTS
*
* LISTEN FOR AN INCOMING CONNECTION
*
LISTENTCP
 LDA #<S0CR
 STA WADRL
 LDA #SCLISTEN ; LISTEN
 STA WDATA
*
* CHECK FOR LISTENING STATUS
*
 LDA #<S0SR
 STA WADRL
 LDA WDATA
 CMP #STLISTEN
 BEQ CHECKESTAB ; WAIT FOR A CONNECTION
* SOCKET LISTEN COMMAND FAILED
 JSR BELL1
 LDA #<S0CR
 STA WADRL
 LDA #SCCLOSE
 STA WDATA
 JMP START
*
* OPEN AN ACTIVE CONNECTION TO A REMOTE HOST
*
CONNECTTCP
 LDA #<S0CR
 STA WADRL
 LDA #SCCONNECT ; CONNECT
 STA WDATA
*
* NOW WAIT FOR TCP TO CONNECT AND BECOME ESTABLISHED
*
CHECKESTAB
 LDA #<S0SR
 STA WADRL
 LDA WDATA ; GET SOCKET STATUS
 BEQ :ERRDONE ; 0 = SOCKET CLOSED, ERROR
 CMP #STESTABLISHED ; IS IT SOCK_ESTABLISHED?
 BNE CHECKESTAB ; NEED MORE TIME TO ESTABLISH
*
* AT THIS POINT, SOCKET IS READY FOR DATA TRANSMISSION
*
 RTS
*
:ERRDONE
 LDY #0
:L LDA :ERRMSG,Y
 BEQ :DONE
 JSR COUT
 INY
 BNE :L
:DONE JMP DOSWARM
*
:ERRMSG ASC "SOCKET COULD NOT CONNECT - CHECK REMOTE HOST"
 HEX 8D00
*
*
* CHECK FOR ANY RECEIVED DATA
*
CHECKRECV
 LDA #<S0RXRSR ; S0 RECEIVED SIZE REGISTER
 STA WADRL
 LDA WDATA ; HIGH BYTE OF RECEIVED SIZE
 ORA WDATA ; LOW BYTE
 BEQ :NORECV ; NO DATA TO READ
 JMP RECV ; THERE IS DATA TO RECEIVE
*
:NORECV
 SEC
 RTS
*
* THERE IS DATA TO READ. COMPUTE THE PHYSICAL ADDRESS
*
RECV
 LDA #<S0RXRSR ; GET RECEIVED SIZE AGAIN
 STA WADRL
 LDA WDATA
 STA GETSIZE+1 ; HIGH BYTE
 LDA WDATA
 STA GETSIZE ; LOW BYTE
*
* CALCULATE OFFSET ADDRESS USING READ POINTER AND RX MASK
*
 LDA #<S0RXRD
 STA WADRL
 LDA WDATA ; HIGH BYTE
 AND #>RXMASK
 STA GETOFFSET+1
 LDA WDATA ; LOW BYTE
 AND #<RXMASK
 STA GETOFFSET
*
* CALCULATE PHYSICAL ADDRESS WITHIN W5100 RX BUFFER
*
 CLC
 LDA GETOFFSET
 ADC #<RXBASE
 STA GETSTARTADR
 LDA GETOFFSET+1
 ADC #>RXBASE
 STA GETSTARTADR+1
*
* SET BUFFER ADDRESS ON APPLE
*
 LDA #0 ; LOW BYTE OF BUFFER
 STA PTR
 LDA #$50 ; HIGH BYTE
 STA PTR+1
*
* SET BUFFER ADDRESS ON W5100
*
 LDA GETSTARTADR+1 ; HIGH BYTE FIRST
 STA WADRH
 LDA GETSTARTADR
 STA WADRL
*
* BEGIN COPY - SET HI-BIT ON EVERYTHING
*
 LDY #0
 LDX GETSIZE+1
 BEQ :LAST ; LESS THAN 256 BYTES
:L LDA WDATA
 ORA #%10000000
 STA (PTR),Y
 INY
 BNE :L
 INC PTR+1
 DEX
 BNE :L
:LAST
 LDX GETSIZE
:L2 LDA WDATA
 ORA #%10000000
 STA (PTR),Y
 INY
 DEX
 BNE :L2
*
* UPDATE RXRD TO REFLECT DATA WE JUST READ
*
 CLC
 LDA #>S0RXRD ; NEED HIGH BYTE HERE
 STA WADRH
 LDA #<S0RXRD
 STA WADRL
 LDA WDATA ; HIGH BYTE
 TAY  ; SAVE
 LDA WDATA ; LOW BYTE
 ADC GETSIZE ; ADD LOW BYTE OF RECEIVED SIZE
 TAX  ; SAVE
 TYA  ; GET HIGH BYTE BACK
 ADC GETSIZE+1 ; ADD HIGH BYTE OF RECEIVED SIZE
 TAY  ; SAVE
 LDA #<S0RXRD
 STA WADRL
 STY WDATA ; SEND HIGH BYTE
 STX WDATA ; SEND LOW BYTE
*
* SEND THE RECV COMMAND
*
 LDA #<S0CR
 STA WADRL
 LDA #SCRECV
 STA WDATA
 CLC  ; NO ERROR
 RTS
*
* CLOSE TCP CONNECTION
*
CLOSECONN
 LDA #>S0CR ; HIGH BYTE NEEDED
 STA WADRH
 LDA #<S0CR
 STA WADRL
 LDA #SCDISCON ; DISCONNECT
 STA WDATA ; SEND COMMAND
*
* CHECK FOR CLOSED STATUS
*
CHECKCLOSED
 LDA #<S0SR
 STA WADRL
 LDA WDATA
 BNE CHECKCLOSED ; NOT CLOSED YET
 RTS  ; SOCKET IS CLOSED
*
* SEND DATA
*
SEND
 LDA #>S0TXFSR ; CHECK TX FREE SIZE
 STA WADRH
:CHECKFREE
 LDA #<S0TXFSR
 STA WADRL
*
* IS FREE SIZE LESS THAN OUTPLEN?
*
 LDA WDATA
 LDX WDATA
 CPX OUTPLEN
 SBC OUTPLEN+1
 BCC :CHECKFREE
*
* CALCULATE OFFSET ADDRESS
* AND APPLY THE TX MASK
*
 LDA #<S0TXWR
 STA WADRL
 LDA WDATA ; HI-BYTE
 AND #>TXMASK
 STA GETOFFSET+1
 LDA WDATA ; LO-BYTE
 AND #<TXMASK
 STA GETOFFSET
*
* CALCULATE BUFFER START ADDRESS
*
 CLC
 ADC #<TXBASE
 TAX
 LDA GETOFFSET+1
 ADC #>TXBASE
*
* SET BUFFER START ADDRESS ON W5100
*
 STA WADRH
 STX WADRL
*
* THIS IS WHERE WE SEND THE USER'S DATA
*
 LDY #0
 LDX OUTPLEN+1
 BEQ :END ; ONLY ONE PAGE OF DATA TO SEND
:L2 LDA (OUTPBUF),Y
 AND #$7F
 STA WDATA
 INY
 BNE :L2
 INC OUTPBUF+1
 DEX ; NEXT BLOCK OF 256 BYTES
 BNE :L2
 LDA OUTPLEN
 BEQ :DONE ; EXACT MULTIPLE OF 256
:END
 LDA (OUTPBUF),Y
 AND #$7F
 STA WDATA
 INY
 CPY OUTPLEN ; DONE YET?
 BNE :END
*
* FINISH SEND OPERATION
* INCREASE S0TXWR BY OUTPLEN
*
:DONE
 LDA #>S0TXWR
 STA WADRH
 LDA #<S0TXWR
 STA WADRL
 CLC
 LDA WDATA ; HIGH BYTE
 TAY
 LDA WDATA ; LOW BYTE
 ADC OUTPLEN
 TAX
 TYA
 ADC OUTPLEN+1
 TAY
 LDA #<S0TXWR
 STA WADRL
 STY WDATA ; HIGH BYTE
 STX WDATA ; LOW BYTE
*
* SET THE SEND COMMAND
*
 LDA #<S0CR
 STA WADRL
 LDA #SCSEND ; SEND
 STA WDATA
*
* CHECK SEND COMPLETION
*
:CHECKSENDOK
 LDA #<S0CR
 STA WADRL
 LDA WDATA
 BEQ :SENDOK ; 0 STATUS = SEND COMPLETE
 NOP
 BNE :CHECKSENDOK ; CHECK AGAIN
:SENDOK
 CLC
 RTS
